
/*******************************************************************************/
/*  
	This script produces Figure 3 	
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/


//________________________________________________________________
// Load CPS Covid Module 
use "../Data/CPS/cps_covid", clear


//________________________________________________________________
// COLLAPSE
gen employed   = inrange(empstat,10,12) // not Military, not U, not NILF
keep if employed
collapse (sum) employed (mean) covidunaw covidtelew [pw=compwt], by(month year occ_2digit) fast

//________________________________________________________________
// ESSENTIAL CLASSIFICATION
merge m:1 occ_2digit using "../Data/DHS/occ2digit_essential"
gen cuttoff   	= 0.75
gen essential 	= share_essential >= cuttoff
drop _merge 

//________________________________________________________________
// LWFH* and HPP*
merge m:1 occ_2digit using "../Data/2_digit_pp_wfh_onet" // pp/wfh scores
keep if _merge == 3
drop _merge 

//________________________________________________________________
// BINARY VERSIONS OF THE VARIABLE
gen low_wfh_binary = .
replace low_wfh_binary = 1 if low_wfh > 0.1667
replace low_wfh_binary = 0 if low_wfh <= 0.1667

gen high_pp_binary = .
replace high_pp_binary = 1 if pp > 0.58632892
replace high_pp_binary = 0 if pp <= 0.58632892



// ------------------------------------------------------
// MAY SHARE TELEWORKING
// ------------------------------------------------------

graph drop _all
format %4.2f covidtelew 
format %2.1f low_wfh pp 

keep if month == 5
//________________________________________________________________
// LWFH
twoway ///
	(scatter covidtelew low_wfh [aw=employed] if !essential, mc(none) sort mlcolor(blue) mlwidth(medthick)) ///
	(scatter covidtelew low_wfh [aw=employed] if essential, mc(none) sort mlcolor(red) mlwidth(medthick)) ///
	(lfitci covidtelew low_wfh  if !essential [aw=employed], level(90) ciplot(rline) alcolor(blue) alwidth(medthick) alpattern(_) clcolor(blue) clwidth(vthick)) ///
	, ytitle("Share teleworking due to Covid (May)", size(vlarge)) ///
	xtitle("Low work-from-home >>" , size(huge)) ///
	legend(pos(2) cols(1) order(1 "Non-essential" 2 "Essential") size(14pt)) ///
	xsize(5) ysize(4)  ///
	yscale(r(-0.2 1.0)) ///
	title("A. Work-from-home") name(Y1) 

//________________________________________________________________
// LWFH
twoway ///
	(scatter covidtelew pp [aw=employed] if !essential, mc(none) sort mlcolor(blue) mlwidth(medthick)) ///
	(scatter covidtelew pp [aw=employed] if essential, mc(none) sort mlcolor(red) mlwidth(medthick)) ///
	(lfitci covidtelew pp if !essential [aw=employed], level(90) ciplot(rline) alcolor(blue) alwidth(medthick) alpattern(_) clcolor(blue) clwidth(vthick)) ///
	, ytitle("Share teleworking due to Covid (May)", size(vlarge)) ///
	xtitle("High physical-proximity >>" , size(huge)) ///
	legend(off) ///
	yscale(r(-0.2 1.0)) ///
	xsize(5) ysize(4)  ///
	title("B. Physical-proximity") name(Y2) 

graph combine Y1 Y2, xcommon // ycommon
graph export "../Figures/fig3.eps", replace
//end
